// // // // // // // // // // // // // // // // // // // //
//	
//	Effector
//	
//	created Apr/13/98 by Andreas Warnke
//	last mod Mai/17/98 by Andreas Warnke
//	
//	This class has methods to send Messages to
//	the Server.
//



// // // // // // // // // // // // // // // // // // // //
//	
//	#pragma once
//

#ifndef Effector_h_
#define Effector_h_



// // // // // // // // // // // // // // // // // // // //
//	
//	#include
//

#include <Be.h>
#include "ConnectionData.h"



// // // // // // // // // // // // // // // // // // // //
//	
//	Effector Declaration
//

class Effector : public virtual BLooper, protected virtual ConnectionData
{
protected:
	//	Send Login Message (returns true <=> message sent):
	bool Login (
		const char * inName,
		const char * inPassword,
		const char * inReadOnlyPassword = NULL );
	
	//	Send Move (returns true <=> message sent):
	bool Move (
		unsigned int inObjectID,
		int inToX,
		int inToY );
		
	//	What to do, if Server died? Called by Move()
	virtual void ServerDied () {};
	
	//	Constructor:
	Effector ();
	
	//	Destructor:
	virtual ~Effector ();
};



#endif



//	
//	The End.
//	
// // // // // // // // // // // // // // // // // // // //